/* -LICENSE-START-
 ** Copyright (c) 2012 Blackmagic Design
 **
 ** Permission is hereby granted, free of charge, to any person or organization
 ** obtaining a copy of the software and accompanying documentation covered by
 ** this license (the "Software") to use, reproduce, display, distribute,
 ** execute, and transmit the Software, and to prepare derivative works of the
 ** Software, and to permit third-parties to whom the Software is furnished to
 ** do so, all subject to the following:
 **
 ** The copyright notices in the Software and this entire statement, including
 ** the above license grant, this restriction and the following disclaimer,
 ** must be included in all copies of the Software, in whole or in part, and
 ** all derivative works of the Software, unless such copies or derivative
 ** works are solely in the form of machine-executable object code generated by
 ** a source language processor.
 **
 ** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 ** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 ** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 ** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 ** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 ** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 ** DEALINGS IN THE SOFTWARE.
 ** -LICENSE-END-
 */
//
// GLExtensions.cpp
// LoopThroughWithOpenGLCompositing
//

#include "GLExtensions.h"

PFNGLGENFRAMEBUFFERSEXTPROC glGenFramebuffersEXT;
PFNGLGENRENDERBUFFERSEXTPROC glGenRenderbuffersEXT;
PFNGLBINDRENDERBUFFEREXTPROC glBindRenderbufferEXT;
PFNGLRENDERBUFFERSTORAGEEXTPROC glRenderbufferStorageEXT;
PFNGLDELETEFRAMEBUFFERSEXTPROC glDeleteFramebuffersEXT;
PFNGLDELETERENDERBUFFERSEXTPROC glDeleteRenderbuffersEXT;
PFNGLBINDFRAMEBUFFEREXTPROC glBindFramebufferEXT;
PFNGLFRAMEBUFFERTEXTURE2DEXTPROC glFramebufferTexture2DEXT;
PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC glFramebufferRenderbufferEXT;
PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC glCheckFramebufferStatusEXT;
PFNGLBLITFRAMEBUFFEREXTPROC glBlitFramebufferEXT;
PFNGLFENCESYNCPROC glFenceSync;
PFNGLCLIENTWAITSYNCPROC glClientWaitSync;
PFNGLDELETESYNCPROC glDeleteSync;
PFNGLGENBUFFERSPROC glGenBuffers;
PFNGLDELETEBUFFERSPROC glDeleteBuffers;
PFNGLBINDBUFFERPROC glBindBuffer;
PFNGLBUFFERDATAPROC glBufferData;
PFNGLCREATESHADERPROC glCreateShader;
PFNGLSHADERSOURCEPROC glShaderSource;
PFNGLCOMPILESHADERPROC glCompileShader;
PFNGLGETSHADERIVPROC glGetShaderiv;
PFNGLGETSHADERINFOLOGPROC glGetShaderInfoLog;
PFNGLCREATEPROGRAMPROC glCreateProgram;
PFNGLATTACHSHADERPROC glAttachShader;
PFNGLLINKPROGRAMPROC glLinkProgram;
PFNGLGETPROGRAMIVPROC glGetProgramiv;
PFNGLGETPROGRAMINFOLOGPROC glGetProgramInfoLog;
PFNGLUSEPROGRAMPROC glUseProgram;
PFNGLGETUNIFORMLOCATIONPROC glGetUniformLocation;
PFNGLUNIFORM1IPROC glUniform1i;
PFNGLUNIFORM1FPROC glUniform1f;

bool ResolveGLExtensions(const QGLContext* context)
{
	glGenFramebuffersEXT = (PFNGLGENFRAMEBUFFERSEXTPROC) context->getProcAddress("glGenFramebuffersEXT");
	glGenRenderbuffersEXT = (PFNGLGENRENDERBUFFERSEXTPROC) context->getProcAddress("glGenRenderbuffersEXT");
	glBindRenderbufferEXT = (PFNGLBINDRENDERBUFFEREXTPROC) context->getProcAddress("glBindRenderbufferEXT");
	glRenderbufferStorageEXT = (PFNGLRENDERBUFFERSTORAGEEXTPROC) context->getProcAddress("glRenderbufferStorageEXT");
	glDeleteFramebuffersEXT = (PFNGLDELETEFRAMEBUFFERSEXTPROC) context->getProcAddress("glDeleteFramebuffersEXT");
	glDeleteRenderbuffersEXT = (PFNGLDELETERENDERBUFFERSEXTPROC) context->getProcAddress("glDeleteRenderbuffersEXT");
	glBindFramebufferEXT = (PFNGLBINDFRAMEBUFFEREXTPROC) context->getProcAddress("glBindFramebufferEXT");
	glFramebufferTexture2DEXT = (PFNGLFRAMEBUFFERTEXTURE2DEXTPROC) context->getProcAddress("glFramebufferTexture2DEXT");
	glFramebufferRenderbufferEXT = (PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC) context->getProcAddress("glFramebufferRenderbufferEXT");
	glCheckFramebufferStatusEXT = (PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC) context->getProcAddress("glCheckFramebufferStatusEXT");
	glBlitFramebufferEXT = (PFNGLBLITFRAMEBUFFEREXTPROC) context->getProcAddress("glBlitFramebufferEXT");
	glFenceSync = (PFNGLFENCESYNCPROC) context->getProcAddress("glFenceSync");
	glClientWaitSync = (PFNGLCLIENTWAITSYNCPROC) context->getProcAddress("glClientWaitSync");
	glDeleteSync = (PFNGLDELETESYNCPROC) context->getProcAddress("glDeleteSync");
	glGenBuffers = (PFNGLGENBUFFERSPROC) context->getProcAddress("glGenBuffers");
	glDeleteBuffers = (PFNGLDELETEBUFFERSPROC) context->getProcAddress("glDeleteBuffers");
	glBindBuffer = (PFNGLBINDBUFFERPROC) context->getProcAddress("glBindBuffer");
	glBufferData = (PFNGLBUFFERDATAPROC) context->getProcAddress("glBufferData");
	glCreateShader = (PFNGLCREATESHADERPROC) context->getProcAddress("glCreateShader");
	glShaderSource = (PFNGLSHADERSOURCEPROC) context->getProcAddress("glShaderSource");
	glCompileShader = (PFNGLCOMPILESHADERPROC) context->getProcAddress("glCompileShader");
	glGetShaderiv = (PFNGLGETSHADERIVPROC) context->getProcAddress("glGetShaderiv");
	glGetShaderInfoLog = (PFNGLGETSHADERINFOLOGPROC) context->getProcAddress("glGetShaderInfoLog");
	glCreateProgram = (PFNGLCREATEPROGRAMPROC) context->getProcAddress("glCreateProgram");
	glAttachShader = (PFNGLATTACHSHADERPROC) context->getProcAddress("glAttachShader");
	glLinkProgram = (PFNGLLINKPROGRAMPROC) context->getProcAddress("glLinkProgram");
	glGetProgramiv = (PFNGLGETPROGRAMIVPROC) context->getProcAddress("glGetProgramiv");
	glGetProgramInfoLog = (PFNGLGETPROGRAMINFOLOGPROC) context->getProcAddress("glGetProgramInfoLog");
	glUseProgram = (PFNGLUSEPROGRAMPROC) context->getProcAddress("glUseProgram");
	glGetUniformLocation = (PFNGLGETUNIFORMLOCATIONPROC) context->getProcAddress("glGetUniformLocation");
	glUniform1i = (PFNGLUNIFORM1IPROC) context->getProcAddress("glUniform1i");
	glUniform1f = (PFNGLUNIFORM1FPROC) context->getProcAddress("glUniform1f");

	return	glGenFramebuffersEXT
			&& glGenRenderbuffersEXT
			&& glBindRenderbufferEXT
			&& glRenderbufferStorageEXT
			&& glDeleteFramebuffersEXT
			&& glDeleteRenderbuffersEXT
			&& glBindFramebufferEXT
			&& glFramebufferTexture2DEXT
			&& glFramebufferRenderbufferEXT
			&& glCheckFramebufferStatusEXT
			&& glBlitFramebufferEXT
			&& glFenceSync
			&& glClientWaitSync
			&& glDeleteSync
			&& glGenBuffers
			&& glDeleteBuffers
			&& glBindBuffer
			&& glBufferData
			&& glCreateShader
			&& glShaderSource
			&& glCompileShader
			&& glGetShaderiv
			&& glGetShaderInfoLog
			&& glCreateProgram
			&& glAttachShader
			&& glLinkProgram
			&& glGetProgramiv
			&& glGetProgramInfoLog
			&& glUseProgram
			&& glGetUniformLocation
			&& glUniform1i
			&& glUniform1f
			;
}
